﻿#Study data verification
#count the number of rows (participants) in the datafile
nrow(carbon1)


#calculate the % women and men
tab1(carbon1$gender_M0W1, sort.group = "decreasing", cum.percent = TRUE)


#calculate the average and standard deviation of age
mean(carbon1$age)
sd(carbon1$age)


#calculate median household income
median(carbon1$income)


#calculate the percentage of political affiliation
tab1(carbon1$poli, sort.group = "decreasing", cum.percent = TRUE)


#calculate the average environmental choice
carbon1$prod_avg_env <- (carbon1$product1_envchoice + carbon1$product2_envchoice + carbon1$product3_envchoice + carbon1$product4_envchoice)/4


#create a table showing average product choice, splite by condition (offset vs tax) and political affiliation 
Table1 <- aggregate(carbon1$prod_avg_env, list(carbon1$frame,carbon1$poli),FUN=mean)
Table1_sd <- aggregate(carbon1$prod_avg_env, list(carbon1$frame,carbon1$poli),FUN=sd)
Table1_count <- aggregate(carbon1$prod_avg_env, list(carbon1$frame,carbon1$poli),FUN=count)
Table1 <- merge(Table1, Table1_sd)
Table1 <- merge(Table1, Table1_count)
Table1


#rename table1 variables
names(Table1) = c('Frame','poli','value','sd','count')
Table1


#create standard error for table1
Table1$se <- Table1$sd / sqrt(Table1$count)
Table1


#calculate pooled standard deviations for Democrats
pooled_demo <- sqrt(((Table1$sd[1:1]^2)+(Table1$sd[4:4]^2))/2)
#calculate Cohen's d for Democrats
d_demo <- (Table1$value[1:1]-Table1$value[4:4])/pooled_demo


#calculate pooled standard deviations for Independents
pooled_inde <- sqrt(((Table1$sd[2:2]^2)+(Table1$sd[5:5]^2))/2)
#calculate Cohen's d for Independents
d_inde <- (Table1$value[2:2]-Table1$value[5:5])/pooled_inde


#calculate pooled standard deviations for Independents
pooled_repu <- sqrt(((Table1$sd[3:3]^2)+(Table1$sd[6:6]^2))/2)
#calculate Cohen's d for Independents
d_repu <- (Table1$value[3:3]-Table1$value[6:6])/pooled_repu


#display all
d_demo
d_inde
d_repu




#Figure 1
#create Figure 1
figure1 <- ggplot(data = Table1,aes(x = poli,y = value,fill = Frame))+ geom_col(position = 'dodge', width = 0.5)+scale_y_continuous(limits = c(0, 1))+ylab("Proportion Choosing the Costlier Product")+ xlab("Political Affiliation")+ scale_fill_manual(values = c("#FFFFFF", "#808080"))+geom_errorbar(aes(ymin=value-se, ymax=value+se),width=.2,position=position_dodge(.5))+theme_bw()+theme(panel.grid=element_blank())
figure1


#chubbier Figure 1
figure1 <- ggplot(data = Table1, aes(x = poli,y = value,fill = Frame)) + geom_bar(stat = "identity", position = position_dodge(),colour = "black")+scale_y_continuous(limits = c(0, 1),breaks=seq(0,1,0.1))+ylab("Proportion Choosing the Costlier Product")+ xlab("Political Affiliation")+ scale_fill_manual(values = c("#FFFFFF", "#808080"))+geom_errorbar(aes(ymin=value-se, ymax=value+se),width=.2,position=position_dodge(.9))+theme_bw()+theme(panel.grid=element_blank())
figure1


#create a new plot window (Windows version)
#windows()
#create a new plot window (Mac version)
quartz()


#alternate version of Figure 1 chubbier imcomplete
figure1_2 <- ggplot(data = Table1, aes(x = poli, y = value, fill = frame)) + geom_bar(stat = "identity", position = position_dodge())
figure1_2


#Figure 2
#recode the data according to scale mentioned in the paper
carbon1$product1_envmandatory<-recode(carbon1$product1_envmandatory, '7'=3, '6'=2, '5'=1, '4'=0, '3'=-1,'2'=-2,'1'=-3)
carbon1$product2_envmandatory<-recode(carbon1$product2_envmandatory, '7'=3, '6'=2, '5'=1, '4'=0, '3'=-1,'2'=-2,'1'=-3)
carbon1$product3_envmandatory<-recode(carbon1$product3_envmandatory, '7'=3, '6'=2, '5'=1, '4'=0, '3'=-1,'2'=-2,'1'=-3)
carbon1$product4_envmandatory<-recode(carbon1$product4_envmandatory, '7'=3, '6'=2, '5'=1, '4'=0, '3'=-1,'2'=-2,'1'=-3)


#calculate the average support for regulation
carbon1$prod_avg_man <- (carbon1$product1_envmandatory + carbon1$product2_envmandatory + carbon1$product3_envmandatory + carbon1$product4_envmandatory)/4


#create a table showing average product choice, splite by condition (offset vs tax) and political affiliation 
Table2 <- aggregate(carbon1$prod_avg_man, list(carbon1$frame,carbon1$poli),FUN=mean)
Table2_sd <- aggregate(carbon1$prod_avg_man, list(carbon1$frame,carbon1$poli),FUN=sd)
Table2_length <- aggregate(carbon1$prod_avg_man, list(carbon1$frame,carbon1$poli),FUN=length)
Table2 <- merge(Table2, Table2_sd)
Table2 <- merge(Table2, Table2_length)
Table2


#rename table2 variables
names(Table2) = c('Frame','poli','value','sd','length')
Table2


#create standard error for table2
Table2$se <- Table2$sd / sqrt(Table2$length)
Table2


#create Figure 2
figure2 <- ggplot(data = Table2, aes(x = poli,y = value,fill = Frame)) + geom_bar(stat = "identity",position = position_dodge(),colour = "black")+scale_y_continuous(limits = c(-2, 2),breaks=seq(-2,2,0.5))+ylab("Mean Support for Regulation")+ xlab("Political Affiliation")+ scale_fill_manual(values = c("#FFFFFF", "#808080"))+geom_errorbar(aes(ymin=value-se, ymax=value+se),width=.2,position=position_dodge(.9))+theme_bw()+theme(panel.grid=element_blank())
figure2


#Regression
#do a logistic regression to predict flight choices based on frame and political affiliation
model1 <- glm(product1_envchoice ~ frame1_offset1 + political_affiliation + frame1_offset1*political_affiliation, family = binomial(link = "logit"), carbon1)
summary(model1)


#hierarchical logistic regression example: https://www.rensvandeschoot.com/tutorials/generalised-linear-models-with-glm-and-lme4/
# Model_Multi_Intercept <- glmer(formula = REPEAT ~ 1 + (1|SCHOOLID),
#                               family = binomial(logit),
#                               data = ThaiEdu_Center,
#                               control = glmerControl(optimizer = "bobyqa", optCtrl = list(maxfun=2e5)))
#
#summary(Model_Multi_Intefigure1 <- ggplot(data = Table1,aes(x = poli,y = value,fill = frame))+ geom_col(position = 'dodge', width = 0.5)+ylab("Proportion Choosing the Costlier Product")+ xlab("Political Affiliation")+ scale_fill_manual(values = c("#808080", "#FFFFFF"))+scale_y_continuous(breaks = seq(0, 2, 0.1))rcept)